//
//  CRBatchCollectionView.h
//  CRGraphics
//
//  Created by Yaroslav Glushchenko on 12/9/10.
//  Copyright 2010 Corner-A. All rights reserved.
//

@class CRPreset;
@class CRSharedRenderer;

//////////////////////////////////////////////////////////////////////
// Batch processing collection view
//
// Somewhere similar to the CRPresetsCollectionView, however, this one
// process a lot of images with a single preset (opposite to "presets"
// collection, that renders a lots of presets for a single image).
//////////////////////////////////////////////////////////////////////
@interface CRBatchCollectionView : NSCollectionView
{
@private
	CRPreset*			previewSource;
	CRSharedRenderer*	sharedRenderer;
	NSOperationQueue*	queuePreviews;
}

@property (nonatomic, assign) id delegate;

- (void)setPreviewSource:(CRPreset *)source;
- (void)dropPreviews;
- (void)cleanQueue:(BOOL)cleanRenderer;

@end